import argparse 
import numpy as np 

parser = argparse.ArgumentParser(description='Hypothesis testing with active learning')

parser.add_argument('--DataType', type = str, default = 'longitudinal_IHDP', help = 'PrimaryDrug_ALSFRS_Slope or RILUZOLE_ALSFRS_Slope or RILUZOLE_SumUp_ALSFRS_Slope or PrimaryDrug_SumUp_ALSFRS_Slope or longitudinal_IHDP or Syn or Syn2')

parser.add_argument('--S', type = int, default = 1000, help = 'Sample size')

parser.add_argument('--TestS', type = int, default = 1000, help = 'Sample size of the test set')

parser.add_argument('--Budget', type = int, default = 700, help = 'Maximum query complexity (label budget)') # It is only for synthetic data under the null

parser.add_argument('--Sep', type = float, default = 0.6, help = 'Overlap of two classes')

parser.add_argument('--classifier_num', type = int, default = 10, help = 'The number of classifiers in the ensemble')

parser.add_argument('--noise_var', type = float, default = 0.5, help = 'variance of noise for response')

parser.add_argument('--TestType', type = str, default = 'Longitudinal_SignTest', help = 'Longitudinal_SignTest, MatchPair_SignTest, RegressionType_Longitudinal_SignTest or RegressionType_MatchPair_SignTest')

parser.add_argument('--Preprocess', type = str, default = 'Matching', help = 'Matching or Randomization')

parser.add_argument('--Matchdistance', type = float, default = 0.1, help = 'Distance for searching pairing data')

parser.add_argument('--QS', type = str, default = 'Passive', help = 'query scheme')

parser.add_argument('--Enrichmentcls', type = str, default = 'Ensemble_knn', help = 'Ensemble_LogisticRegression, Ensemble_DecisionTree or Ensemble_knn' )

parser.add_argument('--Bettingcls', type = str, default = 'DecisionTree', help = 'Classifier type')

parser.add_argument('--regressor', type = str, default = 'DecisionTree', help = 'Regresison methods')

parser.add_argument('--ScalingStrategy', type = str, default = 'ONS', help = 'Strategy to choose scaling factor of the payoff function. ONS, MCE, or LowerBound')

parser.add_argument('--Per', type = float, default = 1, help = 'Proportion of unlabelled pool')

parser.add_argument('--Interval', type = float, default = 0.1, help = 'percentage increment')

parser.add_argument('--Thres', type = float, default = 0.49, help = 'Threshold for the acquisition function')

parser.add_argument('--RespondingThres', type = float, default = 4.5, help = 'Threshold for defining the responding region')

parser.add_argument('--SeqStartPoint', type = int, default = 10, help = 'Size of initiation set')

parser.add_argument('--Alpha', type = float, default = 0.05, help = 'Significance level')

parser.add_argument('--Trial', type = int, default = 1, help = 'Trial number')

parser.add_argument('--RunTest', type = int, default = 1, help = 'If run the test')

parser.add_argument('--Draw_SyntheticData_Results', type = int, default = 0, help = 'Draw matching data in the classification view and the quering results')

parser.add_argument('--Plot_TypeII', type = int, default = 0, help = 'Get Type II errors')

parser.add_argument('--Plot_TypicalHypothesis', type = int, default = 0, help = 'Plot Type II errors for typical hypothesis ')

parser.add_argument('--Plot_ActiveSWResultsComp', type = int, default = 0, help = 'Plot Type II errors for active sequential schemes ')

parser.add_argument('--Plot_TypeI', type = int, default = 0, help = 'Plot Type I errors ')

parser.add_argument('--print_results_alongbudgets', type = int, default = 0, help = 'Print Results along budgets')

parser.add_argument('--print_effectsize_alonglabels', type = int, default = 0, help = 'Print Results along budgets')

parser.add_argument('--Plot_ScalingStrategy', type = int, default = 0, help = 'Plot Type II errors for different scaling Strategies')

parser.add_argument('--Plot_SeqandBatchTypeII', type = int, default = 0, help = 'Plot Type II error to compare active sequential and the batch test that uses all labels')

parser.add_argument('--Plot_ActiveDifferentES', type = int, default = 0, help = 'Plot Type II error to compare active sequential testing for different effect sizes')

parser.add_argument('--Plot_DiffHypothesis', type = int, default = 0, help = 'Plot Type II error for betting or LR for two different huypothesis data.')

parser.add_argument('--Draw_PickedCovariates', type = int, default = 0, help = 'Draw the region of picked covariates.')

parser.add_argument('--Draw_ClassifierProbabilities', type = int, default = 0, help = 'Draw the histogram of classifier probabilities')

parser.add_argument('--Print_Correlation', type = int, default = 0, help = 'Print the correlation between the features and labels in the classifiation dataset')

parser.add_argument('--print_acc', type = int, default = 0, help = 'Plot the accuracy of the classifier trained by passive/active learning')

parser.add_argument('--LoadQuery', type = int, default = 0, help = 'whether load query index or not')

parser.add_argument('--SaveQuery', type = int, default = 0, help = 'whether save query index or not')

parser.add_argument('--SaveStats', type = int, default = 0, help = 'whether save the statistic of a test or not')

parser.add_argument('--SaveEnrichmentProb', type = int, default = 0, help = 'whether save the classifier output probabilities')

parser.add_argument('--EarlyStopping', type = int, default = 0, help = 'Stop the algorithm once H_0 is rejected')

parser.add_argument('--scale', type = float, default = 0.01, help = 'The scale of a kernel')




